<?php
$itemsHoverEffets = [
	"classic"				=> __("Classic", "smart-footer-system"),
	"brackets" 				=> __("Brackets", "smart-footer-system"),
	"underline-border" 	    => __("Underline border", "smart-footer-system"),
	"text-sub" 				=> __("Text substitution", "smart-footer-system"),
	"text-accordion" 		=> __("Text accordion", "smart-footer-system"),
];
$allMenus = get_terms( 'nav_menu', array( 'hide_empty' => true ) );

$socials = [
	"facebook",
	"twitter",
	"instagram",
	"youtube",
	"google-plus",
	"pinterest",
	"flickr",
	"tumblr"
];
?>
<div class="table-tabs">
	<a data-tabtarget="menuf-query-settings" href="javascript:;"><?php echo __("Settings", "smart-footer-system") ?></a>
	<a data-tabtarget="menuf-query-items" href="javascript:;"><?php echo __("Items", "smart-footer-system") ?></a>
	<a data-tabtarget="menuf-query-socials" href="javascript:;"><?php echo __("Socials", "smart-footer-system") ?></a>
</div>
<div class="tab-targets">
	<div class="tab-target" data-tabtarget="menuf-query-settings">
		<table class="form-table sfs-table sfs-table-full" data-tabtarget="menuf-query-settings">
			<tbody>
				<tr>
					<th>
						<label data-hint="<?php echo __("Choose the menu that you want to display in your footer", "smart-footer-system"); ?>" for=""><?php echo __("Menu", 'smart-footer-system') ?></label>
					</th>
					<td>
						<select name="sfs[menuf][menu-id]" id="">
							<option <?php echo (!isset($sfsFooterSettings['menuf']['menu-id']) || $sfsFooterSettings['menuf']['menu-id'] == 'none') ? 'selected' : '' ?> value="none">none</option>
							<?php foreach($allMenus as $menu): ?>
								<option <?php echo (isset($sfsFooterSettings['menuf']['menu-id']) && $sfsFooterSettings['menuf']['menu-id'] == $menu->term_id) ? 'selected' : '' ?> value="<?php echo $menu->term_id ?>"><?php echo $menu->name ?></option>
							<?php endforeach; ?>
						</select>
					</td>
				</tr>
				<tr>
					<th>
						<label data-hint="<?php echo __("Choose the type for your border", "smart-footer-system"); ?>" for="sfs-footer-menuf-overlay-color"><?php echo __("Divider Type", 'smart-footer-system') ?></label>
					</th>
					<td>
						<select name="sfs[menuf][border-type]" id="sfs-footer-menuf-menu-border-type-select">
							<option <?php echo (!isset($sfsFooterSettings["menuf"]["border-type"]) || $sfsFooterSettings["menuf"]["border-type"] == 'none') ? 'selected' : '' ?> value="none">none</option>
							<option <?php echo (isset($sfsFooterSettings["menuf"]["border-type"]) && $sfsFooterSettings["menuf"]["border-type"] == 'solid') ? 'selected' : '' ?> value="solid">solid</option>				
							<option <?php echo (isset($sfsFooterSettings["menuf"]["border-type"]) && $sfsFooterSettings["menuf"]["border-type"] == 'dotted') ? 'selected' : '' ?> value="dotted">dotted</option>
							<option <?php echo (isset($sfsFooterSettings["menuf"]["border-type"]) && $sfsFooterSettings["menuf"]["border-type"] == 'dashed') ? 'selected' : '' ?> value="dashed">dashed</option>
							<option <?php echo (isset($sfsFooterSettings["menuf"]["border-type"]) && $sfsFooterSettings["menuf"]["border-type"] == 'double') ? 'selected' : '' ?> value="double">double</option>
							<option <?php echo (isset($sfsFooterSettings["menuf"]["border-type"]) && $sfsFooterSettings["menuf"]["border-type"] == 'groove') ? 'selected' : '' ?> value="groove">groove</option>
							<option <?php echo (isset($sfsFooterSettings["menuf"]["border-type"]) && $sfsFooterSettings["menuf"]["border-type"] == 'ridge') ? 'selected' : '' ?> value="ridge">ridge</option>
							<option <?php echo (isset($sfsFooterSettings["menuf"]["border-type"]) && $sfsFooterSettings["menuf"]["border-type"] == 'inset') ? 'selected' : '' ?> value="inset">inset</option>
							<option <?php echo (isset($sfsFooterSettings["menuf"]["border-type"]) && $sfsFooterSettings["menuf"]["border-type"] == 'outset') ? 'selected' : '' ?> value="outset">outset</option>
						</select>
					</td>
				</tr>
				<tr id="sfs-footer-menuf-menu-divider-size-tr">
					<th>
						<label data-hint="<?php echo __("Choose the size of your divider", "smart-footer-system"); ?>" for=""><?php echo __("Divider size", 'smart-footer-system') ?></label>
					</th>
					<td>
						<input name="sfs[menuf][divider-size]" class="regular-text" type="number" min= "0" max="100" step="1" value="<?php echo (isset($sfsFooterSettings['menuf']['divider-size'])) ? $sfsFooterSettings['menuf']['divider-size'] : '' ?>"> <span style="margin-top:5px; display:inline-block">px</span>
					</td>
				</tr>
				<tr id="sfs-footer-menuf-menu-border-color-tr">
					<th>
						<label data-hint="<?php echo __("Choose the color that you want to divide your menu", "smart-footer-system"); ?>" for=""><?php echo __("Divider color", 'smart-footer-system') ?></label>
					</th>
					<td>
						<input name="sfs[menuf][divider-color]" class="sfs-color-picker" type="text" value="<?php echo (isset($sfsFooterSettings['menuf']['divider-color'])) ? $sfsFooterSettings['menuf']['divider-color'] : '' ?>">
					</td>
				</tr>
			</tbody>
		</table>
	</div>
	<div class="tab-target" data-tabtarget="menuf-query-items">
		<table class="form-table sfs-table sfs-table-full">
			<tbody>
				<tr id="sfs-footer-menuf-menu-gap-tr">
					<th>
						<label data-hint="<?php echo __("Choose the horizontal gap of your menu items", "smart-footer-system"); ?>" for=""><?php echo __("Horizontal Gap", 'smart-footer-system') ?></label>
					</th>
					<td>
						<input name="sfs[menuf][h-gap]" class="regular-text" type="number" min= "1" max="100" step="1" value="<?php echo (isset($sfsFooterSettings['menuf']['h-gap'])) ? $sfsFooterSettings['menuf']['h-gap'] : '' ?>"> <span style="margin-top:5px; display:inline-block">px</span>
					</td>
				</tr>	
				<tr id="sfs-footer-menuf-menu-gap-tr">
					<th>
						<label data-hint="<?php echo __("Choose the vertical gap of your menu items", "smart-footer-system"); ?>" for=""><?php echo __("Vertical Gap", 'smart-footer-system') ?></label>
					</th>
					<td>
						<input name="sfs[menuf][v-gap]" class="regular-text" type="number" min= "1" max="100" step="1" value="<?php echo (isset($sfsFooterSettings['menuf']['v-gap'])) ? $sfsFooterSettings['menuf']['v-gap'] : '' ?>"> <span style="margin-top:5px; display:inline-block">px</span>
					</td>
				</tr>	
				<tr>
					<th>
						<label data-hint="<?php echo __("Choose the text color for the menu items", "smart-footer-system"); ?>" for=""><?php echo __("Text color", 'smart-footer-system') ?></label>
					</th>
					<td>
						<input name="sfs[menuf][item-text-color]" class="sfs-color-picker" type="text" value="<?php echo (isset($sfsFooterSettings['menuf']['item-text-color'])) ? $sfsFooterSettings['menuf']['item-text-color'] : '' ?>">
					</td>
				</tr>
				<tr>
					<th>
						<label data-hint="<?php echo __("Choose the background color for the menu items", "smart-footer-system"); ?>" for=""><?php echo __("Background color", 'smart-footer-system') ?></label>
					</th>
					<td>
						<input name="sfs[menuf][item-background-color]" class="sfs-color-picker" type="text" value="<?php echo (isset($sfsFooterSettings['menuf']['item-background-color'])) ? $sfsFooterSettings['menuf']['item-background-color'] : '' ?>">
					</td>
				</tr>
				<tr>
					<th>
						<label data-hint="<?php echo __("Choose the hover effect for your menu items", "smart-footer-system"); ?>" for="sfs-footer-menuf-overlay-color"><?php echo __("Hover effect", 'smart-footer-system') ?></label>
					</th>
					<td>
						<select name="sfs[menuf][hover-effect]" id="sfs-footer-menuf-menu-hover-effect-select">
							<option <?php echo (!isset($sfsFooterSettings["menuf"]["hover-effect"]) || $sfsFooterSettings["menuf"]["hover-effect"] == 'none') ? 'selected' : '' ?> value="none">none</option>
							<?php foreach($itemsHoverEffets as $itemHoverEffect => $itemHoverEffectLabel): ?>
								<option <?php echo (isset($sfsFooterSettings["menuf"]["hover-effect"]) && $sfsFooterSettings["menuf"]["hover-effect"] == $itemHoverEffect) ? 'selected' : '' ?> value="<?php echo $itemHoverEffect ?>"><?php echo $itemHoverEffectLabel ?></option>
							<?php endforeach; ?>
						</select>
					</td>
				</tr>
				<tr class="sfs-footer-menuf-menu-hover-effect-tr">
					<th>
						<label data-hint="<?php echo __("Choose the hover color for the menu items", "smart-footer-system"); ?>" for=""><?php echo __("Hover color", 'smart-footer-system') ?></label>
					</th>
					<td>
						<input name="sfs[menuf][item-hover-color]" class="sfs-color-picker" type="text" value="<?php echo (isset($sfsFooterSettings['menuf']['item-hover-color'])) ? $sfsFooterSettings['menuf']['item-hover-color'] : '' ?>">
					</td>
				</tr>
			</tbody>
		</table>
	</div>
	<div class="tab-target" data-tabtarget="menuf-query-socials">
		<table class="form-table sfs-table sfs-table-full">
			<tbody>
				<?php foreach($socials as $social): ?>
					<tr>
						<th>
							<label data-hint="<?php echo __("Enter the link of your social. Leave empty to not display it", "smart-footer-system"); ?>" for=""><?php echo ucfirst($social); ?></label>
						</th>
						<td>
							<input name="sfs[menuf][socials][<?php echo $social; ?>]" class="regular-text" type="text" value="<?php echo (isset($sfsFooterSettings['menuf']['socials'][$social])) ? $sfsFooterSettings['menuf']['socials'][$social] : '' ?>">
						</td>
					</tr>
				<?php endforeach; ?>
			</tbody>
		</table>
	</div>
</div>